/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.FileType;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoXMLProperties;
import DE.siemens.ad.udf.UDFFactory;
import DE.siemens.ad.udf.UDFLibrary;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UDFLibraryDialog
extends JFrame
implements ActionListener {
    private JPanel ivjUDFLibraryPane = null;
    private JButton ivjAddUDFButton = null;
    private JButton ivjAddFolderButton = null;
    private JButton ivjRemoveButton = null;
    private JTree ivjUDFLibraryTree = null;
    private DefaultMutableTreeNode ivjselectedNode = null;

    public UDFLibraryDialog() {
        try {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(Language.getString("dialog.options.UDFLibrary.treeRoot", "UDF Library"));
            this.ivjUDFLibraryTree = new JTree(root);
            DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
            treeSelectionModel.setSelectionMode(1);
            this.ivjUDFLibraryTree.setSelectionModel(treeSelectionModel);
            this.ivjUDFLibraryTree.addTreeSelectionListener(new UDFLibrarySelectionHandler());
            this.ivjUDFLibraryTree.setCellRenderer(new UDFLibCellRenderer());
            this.ivjUDFLibraryTree.setVisibleRowCount(18);
            List<String> paths = LogoXMLProperties.getInstance().getLibraryProperties(true);
            for (String path : paths) {
                root.add(new DefaultMutableTreeNode(path));
            }
            this.ivjUDFLibraryTree.updateUI();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.ivjUDFLibraryTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                TreePath tp = UDFLibraryDialog.this.ivjUDFLibraryTree.getSelectionPath();
                if (tp != null && ((TreeNode)tp.getLastPathComponent()).isLeaf() && !((DefaultMutableTreeNode)tp.getLastPathComponent()).isRoot()) {
                    if (me.getClickCount() == 1) {
                        UDFLibraryDialog.this.ivjselectedNode = (DefaultMutableTreeNode)tp.getLastPathComponent();
                        UDFLibraryDialog.this.ivjRemoveButton.setEnabled(true);
                    }
                    if (me.getClickCount() == 2) {
                        // empty if block
                    }
                } else {
                    UDFLibraryDialog.this.ivjRemoveButton.setEnabled(false);
                }
            }
        });
    }

    private void handleException(Throwable exception) {
    }

    public JTree getUDFLibraryTree() {
        return this.ivjUDFLibraryTree;
    }

    private JButton getAddUDFButton() {
        if (this.ivjAddUDFButton == null) {
            try {
                this.ivjAddUDFButton = new JButton();
                this.ivjAddUDFButton.setName("AddUDFButton");
                this.ivjAddUDFButton.setEnabled(true);
                this.ivjAddUDFButton.setText(Language.getString("dialog.options.UDFLibrary.addUDF", "Add UDF"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
            this.ivjAddUDFButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent me) {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setDialogTitle(Language.getString("dialog.options.UDFLibrary.selection", "UDF Selection"));
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setMultiSelectionEnabled(true);
                    FileType udf = FileType.getFileType("lma", "UDF files", Global.getIcon("UDFDefaultIcon.gif"));
                    fileChooser.setFileFilter(udf);
                    if (fileChooser.showOpenDialog(UDFLibraryDialog.this) == 0) {
                        UDFLibraryDialog.this.addLibrary(fileChooser);
                    }
                }
            });
        }
        return this.ivjAddUDFButton;
    }

    private JButton getAddFolderButton() {
        if (this.ivjAddFolderButton == null) {
            try {
                this.ivjAddFolderButton = new JButton();
                this.ivjAddFolderButton.setName("AddFolderButton");
                this.ivjAddFolderButton.setEnabled(true);
                this.ivjAddFolderButton.setText(Language.getString("dialog.options.UDFLibrary.addFolder", "Add Folder"));
                this.ivjAddFolderButton.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent me) {
                        JFileChooser fileChooser = new JFileChooser();
                        fileChooser.setDialogTitle(Language.getString("dialog.options.UDFLibrary.folderSelection", "UDF Folder Selection"));
                        fileChooser.setMultiSelectionEnabled(true);
                        fileChooser.setFileSelectionMode(1);
                        if (fileChooser.showOpenDialog(UDFLibraryDialog.this) == 0) {
                            UDFLibraryDialog.this.addLibrary(fileChooser);
                        }
                    }
                });
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAddFolderButton;
    }

    private JButton getRemoveButton() {
        if (this.ivjRemoveButton == null) {
            try {
                this.ivjRemoveButton = new JButton();
                this.ivjRemoveButton.setName("RemoveButton");
                this.ivjRemoveButton.setEnabled(false);
                this.ivjRemoveButton.setText(Language.getString("dialog.options.UDFLibrary.remove", "Remove"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
            this.ivjRemoveButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent me) {
                    ((DefaultTreeModel)UDFLibraryDialog.this.ivjUDFLibraryTree.getModel()).removeNodeFromParent(UDFLibraryDialog.this.ivjselectedNode);
                    UDFFactory.instance().addRemoveFile((String)UDFLibraryDialog.this.ivjselectedNode.getUserObject());
                    UDFLibraryDialog.this.ivjUDFLibraryTree.updateUI();
                    UDFLibraryDialog.this.ivjRemoveButton.setEnabled(false);
                }
            });
        }
        return this.ivjRemoveButton;
    }

    public JPanel getUDFLibraryPane() {
        if (this.ivjUDFLibraryPane == null) {
            this.ivjUDFLibraryPane = new JPanel(new BorderLayout());
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(5, 5, 0, 0);
            gbc.fill = 2;
            buttonPanel.add((Component)this.getAddUDFButton(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(5, 5, 0, 0);
            gbc.fill = 2;
            buttonPanel.add((Component)this.getAddFolderButton(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(5, 5, 0, 0);
            gbc.fill = 2;
            buttonPanel.add((Component)this.getRemoveButton(), gbc);
            this.ivjUDFLibraryPane.add((Component)buttonPanel, "East");
            this.ivjUDFLibraryPane.add((Component)new JScrollPane(this.getUDFLibraryTree()), "Center");
        }
        return this.ivjUDFLibraryPane;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getAddUDFButton()) {
            this.ivjRemoveButton.setEnabled(true);
        }
        if (e.getSource() == this.getUDFLibraryTree()) {
            this.ivjRemoveButton.setEnabled(true);
        }
        if (e.getSource() == this.getRemoveButton()) {
            // empty if block
        }
    }

    private void addLibrary(JFileChooser fileChooser) {
        File[] files;
        for (File file : files = fileChooser.getSelectedFiles()) {
            if (!file.exists() || file.isFile() && !file.getName().toLowerCase().endsWith(".lma") || this.isLibrarySelected(file)) continue;
            DefaultMutableTreeNode dm = new DefaultMutableTreeNode(file.getAbsolutePath());
            UDFFactory.instance().addAddFile(file.getAbsolutePath());
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.ivjUDFLibraryTree.getModel().getRoot();
            root.add(dm);
        }
        this.ivjUDFLibraryTree.updateUI();
        this.ivjRemoveButton.setEnabled(false);
    }

    private boolean isLibrarySelected(File file) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.ivjUDFLibraryTree.getModel().getRoot();
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (!child.getUserObject().equals(file.getAbsolutePath()) && !UDFLibrary.isFileIncluded((String)child.getUserObject(), file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    protected class UDFLibCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (((DefaultMutableTreeNode)value).getUserObject() instanceof String) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                String str = (String)((DefaultMutableTreeNode)value).getUserObject();
                int rowHeight = UDFLibraryDialog.this.ivjUDFLibraryTree.getRowHeight();
                ImageIcon icon = null;
                icon = !((DefaultMutableTreeNode)value).isRoot() && !new File(str).exists() ? Global.getIcon("DefaultIcon.gif") : (str.indexOf(".lma") >= 0 ? Global.getIcon("UDFIcon.gif") : Global.getIcon("Favorites.gif"));
                if (rowHeight > 0 && icon.getIconHeight() != rowHeight) {
                    int unscaledHeight = icon.getIconHeight();
                    float scale = (float)rowHeight / (float)unscaledHeight;
                    icon = new ImageIcon(icon.getImage().getScaledInstance((int)((float)icon.getIconWidth() * scale), (int)((float)icon.getIconHeight() * scale), scale > 1.0f ? 2 : 4));
                }
                this.setIcon(icon);
            } else {
                super.getTreeCellRendererComponent(tree, value, false, expanded, leaf, row, hasFocus);
            }
            return this;
        }
    }

    public class UDFLibrarySelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent tse) {
        }
    }
}

